function [maic,maicc,maicu,mbic,mc,mcc,mcu] = criterion_setar2(x,p1max,p2max,dmax)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Example 6.7 (Table 6.1)
% File: criterion_setar2.m
%
% This function gives the "best" selected orders of SETAR(2;p1max,p2max) models. 
%
% INPUT:
% x     = data series.
% p1max = maximum autoregressive order of the first regime
% p2max = maximum autoregressive order of the second regime
% dmax  = maximum delay order
% 
% OUTPUT:
% The outputs are seven vectors, one for each criterion, with the following:
% Estimate of the threshold
% Order p1 selected by the criterion
% Order p2 selected by the criterion
% Estimate of delay
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[si1,~] = size(x);
if si1 > 1
   x = x';
end;   
n   = numel(x);
xx  = sort(x);
rg  = floor(0.25*n):floor(0.75*n);
lrg = length(rg);

maic  = zeros(dmax,4);
maicc = zeros(dmax,4);
maicu = zeros(dmax,4);
mbic  = zeros(dmax,4);
mc    = zeros(dmax,4);
mcc   = zeros(dmax,4);
mcu   = zeros(dmax,4);

for id = 1 : dmax      
    [c1est,c2est,phi1est,phi2est,stderror1,stderror2,sig1est,sig2est,n1,n2] = estimasetar(x,1,1,id,xx(rg(1)));
    
    [sigcv,n1cv,n2cv] = critcv(x,1,1,id,xx(rg(1)));
        
    auxaic = n1*log(sig1est)+n2*log(sig2est)+2*(1+2)+2*(1+2);
    auxaicc = n1*log(sig1est)+n2*log(sig2est)+2*n1*(1+2)/(n1-1-3)+2*n2*(1+2)/(n2-1-3);
    auxaicu = auxaicc + n1*log(n1/(n1-1-2)) + n2*log(n2/(n2-1-2));
    auxbic = n1*log(sig1est)+n2*log(sig2est)+2*(1+1)*log(n1)+2*(1+1)*log(n2);
    auxc = n*log(sigcv);
    auxcc = n*log(sigcv)+2*(1+2)*(1+3)/(n1cv-1-3)+2*(1+2)*(1+3)/(n2cv-1-3);
    auxcu = auxcc + n1cv * log(n1cv/(n1cv-1-2)) + n2cv * log(n2cv/(n2cv-1-2));
    
    maic(id,1:4)  = [xx(rg(1)) 1 1 auxaic];
    maicc(id,1:4) = [xx(rg(1)) 1 1 auxaicc];
    maicu(id,1:4) = [xx(rg(1)) 1 1 auxaicu];
    mbic(id,1:4)  = [xx(rg(1)) 1 1 auxbic];
    mc(id,1:4)    = [xx(rg(1)) 1 1 auxc];
    mcc(id,1:4)   = [xx(rg(1)) 1 1 auxcc];
    mcu(id,1:4)   = [xx(rg(1)) 1 1 auxcu];
    
    for ir = rg(1) : rg(lrg)
        for ip1 = 1 : p1max
            for ip2 = 1 : p2max                
              [c1est,c2est,phi1est,phi2est,stderror1,stderror2,sig1est,sig2est,n1,n2]=estimasetar(x,ip1,ip2,id,xx(ir));
              auxaicb = n1*log(sig1est)+n2*log(sig2est)+2*(ip1+2)+2*(ip2+2);
              if auxaicb < auxaic
                 auxaic = auxaicb;                        
                 maic(id,1:4) = [xx(ir) ip1 ip2 auxaic];
              end
                
              if n1 > (ip1 + 3)
                if n2 > (ip2 + 3)
                   auxaiccb = n1*log(sig1est)+n2*log(sig2est)+2*n1*(ip1+2)/(n1-ip1-3)+2*n2*(ip2+2)/(n2-ip2-3);
                   auxaicub = auxaiccb+n1*log(n1/(n1-ip1-2))+n2*log(n2/(n2-ip2-2));
                   if auxaiccb < auxaicc
                      auxaicc = auxaiccb;                        
                      maicc(id,1:4) = [xx(ir) ip1 ip2 auxaicc];
                   end
                   if auxaicub < auxaicu
                      auxaicu = auxaicub;                        
                      maicu(id,1:4) = [xx(ir) ip1 ip2 auxaicu];
                   end                      
                 end
              end
                                
              auxbicb = n1*log(sig1est)+n2*log(sig2est)+2*(ip1+1)*log(n1)+2*(ip2+1)*log(n2);
              if auxbicb < auxbic
                 auxbic = auxbicb;                        
                 mbic(id,1:4) = [xx(ir) ip1 ip2 auxbic];
              end

              [sigcv,n1cv,n2cv] = critcv(x,ip1,ip2,id,xx(ir));
                                              
              auxcb = n * log(sigcv);
              if auxcb < auxc
                 auxc = auxcb;                        
                 mc(id,1:4) = [xx(ir) ip1 ip2 auxc];
              end

              if n1cv > (ip1 + 3)
                 if n2cv > (ip2 + 3) 
                    auxccb = n*log(sigcv)+2*(ip1+2)*(ip1+3)/(n1cv-ip1-3)+2*(ip2+2)*(ip2+3)/(n2cv-ip2-3);
                    auxcub = auxccb + n1cv*log(n1cv/(n1cv-ip1-2)) + n2cv*log(n2cv/(n2cv-ip2-2));
                    if auxccb < auxcc
                       auxcc = auxccb;                        
                       mcc(id,1:4) = [xx(ir) ip1 ip2 auxcc];
                    end;
                    if auxcub < auxcu
                       auxcu = auxcub;                        
                       mcu(id,1:4) = [xx(ir) ip1 ip2 auxcu];
                    end;
                 end
              end

            end
        end
            
    end
        
end

[mmaic, imaic]   = min(maic(:,4));
[mmaicc, imaicc] = min(maicc(:,4));
[mmaicu, imaicu] = min(maicu(:,4));
[mmbic, imbic]   = min(mbic(:,4));
[mmc, imc]       = min(mc(:,4));
[mmcc, imcc]     = min(mcc(:,4));
[mmcu, imcu]     = min(mcu(:,4));

maic  = [maic(imaic,1:3) imaic];
maicc = [maicc(imaicc,1:3) imaicc];
maicu = [maicu(imaicu,1:3) imaicu];
mbic  = [mbic(imbic,1:3) imbic];
mc    = [mc(imc,1:3) imc];
mcc   = [mcc(imcc,1:3) imcc];
mcu   = [mcu(imcu,1:3) imcu];
